package com.wecloud.im.biz.module.message.service;

import java.util.List;
import java.util.Map;

import com.wecloud.can.datasource.mybatisplus.pagination.Paging;
import com.wecloud.can.datasource.mybatisplus.service.BaseService;
import com.wecloud.im.biz.module.message.controller.param.ClientInfoParam;
import com.wecloud.im.biz.module.message.controller.param.ClientRelationVo;
import com.wecloud.im.biz.module.message.controller.param.GetClientInfoParam;
import com.wecloud.im.biz.module.message.controller.param.GetClientRelationParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientQueryVo;
import com.wecloud.im.biz.module.message.controller.param.ImClientSimpleDto;
import com.wecloud.im.biz.module.message.controller.param.LogoutParam;
import com.wecloud.im.biz.module.message.controller.param.RegisterClientParam;
import com.wecloud.im.biz.module.message.controller.param.add.ClientDeviceUpdateParam;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientHeadPortraitAdd;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientHeadPortraitAndNicknameUpdate;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientNicknameAdd;
import com.wecloud.im.biz.module.message.controller.param.add.ImClientNicknameUpdate;
import com.wecloud.im.biz.module.message.controller.vo.ClientInfoVo;
import com.wecloud.im.biz.module.message.controller.vo.GetInfoListVo;
import com.wecloud.im.biz.module.message.controller.vo.MyInfoVo;
import com.wecloud.im.biz.module.message.entity.ImClient;

/**
 * 终端表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImClientService extends BaseService<ImClient> {

    /**
     * 查询我的信息
     * @return
     */
    MyInfoVo getMyInfo();

    /**
     * 更新头像
     * @param imClientHeadPortraitAdd
     * @return
     */
    boolean updateHeadPortrait(ImClientHeadPortraitAdd imClientHeadPortraitAdd);

    /**
     * 修改昵称
     * @param imClientNicknameUpdate
     * @return
     */
    boolean updateNickname(ImClientNicknameUpdate imClientNicknameUpdate);

    /**
     *
     * @Author luozh
     * @Date 2022年04月18日 07:21:27
     * @param imClientHeadPortraitAndNicknameUpdate
     * @Return
     */
    boolean updateHeadAndNickname(ImClientHeadPortraitAndNicknameUpdate imClientHeadPortraitAndNicknameUpdate);


    /**
     * 根据ids获取Client的头像昵称
     *
     * @param getClientInfoParam
     * @return
     * @throws Exception
     */
    List<GetInfoListVo> getInfoList(GetClientInfoParam getClientInfoParam) throws Exception;

    /**
     * 获取群里成员信息
     * @param param
     * @return
     */
    ClientInfoVo getClientInfo(ClientInfoParam param);


    boolean updateNickname(ImClientNicknameAdd imClientNicknameAdd) throws Exception;

    /**
     * 保存
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean saveImClient(ImClient imClient) throws Exception;

    /**
     * 添加或修改推送设备信息
     *
     * @param imClientDevice
     * @return
     */
    boolean updateDeviceInfo(ClientDeviceUpdateParam imClientDevice);

    /**
     * 登出操作
     * @param param
     * @return
     */
    boolean logout(LogoutParam param);


    /**
     * 修改
     *
     * @param imClient
     * @return
     * @throws Exception
     */
    boolean updateImClient( ImClient imClient) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImClient(Long id);

    /**
     * 获取分页对象
     *
     * @param imClientPageParam
     * @return
     * @throws Exception
     */
    Paging<ImClientQueryVo> getImClientPageList(ImClientPageParam imClientPageParam) throws Exception;


    /**
     * 获取当前请求的client对象
     *
     * @return
     */
    ImClient getCurrentClient();

    ImClient getCacheImClient(Long applicationId, String clientId);

    void deleteCacheImClient(Long applicationId, String clientId);

    /**
     * 根据ID获取client对象，有缓存
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImClient getCacheImClient(Long id);

    /**
     * 获取client的简单对象，减少开销
     * @param applicationId
     * @param clientIds
     * @return
     */
    List<ImClientSimpleDto> getSimpleClients(Long applicationId, List<String> clientIds);

    List<ImClientSimpleDto> getSimpleClients(List<Long> ids);

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 05:20:58
     * @param param
     * @Return
     */
    Long registerClient(RegisterClientParam param);

    /**
     * 获取客户端关系
     * @Author luozh
     * @Date 2022年05月12日 07:04:04
     * @param param
     * @Return
     */
    ClientRelationVo getClientRelation(GetClientRelationParam param);

    Map<String, String> getUserAttributes(String userId);

    Boolean modifyUserAttributes(String userId, Map<String, Object> attributes);
}
