package com.wecloud.im.biz.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;

/**
 * 加入会话方式枚举
 * @Author luozh
 * @Date 2022年05月09日 14:58
 * @Version 1.0
 */
public enum JoinConversationTypeEnum {
    // 会话创建者
    OWNER("OWNER", "会话创建者"),
    // 被邀请
    BE_INVITED("BE_INVITED", "被邀请"),
    ;

    @EnumValue
    private final String code;
    private final String desc;

    JoinConversationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}
