package com.wecloud.im.biz.enums;

import com.wecloud.can.core.base.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/16 15:27
 * @Description 人员在群内角色枚举
 */
public enum GroupRoleEnum implements BaseEnum {

    /**
     * 1-普通群成员
     */
    NORMAL(1, "普通群成员"),

    /**
     * 2 - 管理员
     */
    ADMIN(2, "管理员"),

    /**
     * 3 - 群主
     */
    OWNER(3, "群主");

    GroupRoleEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
