package com.wecloud;

import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import com.wecloud.can.core.util.PrintApplicationInfo;
import com.wecloud.im.biz.core.rocketmq.annotation.EnableRocketMq;

/**
 * 项目启动入口
 */
@EnableDiscoveryClient
@EnableDubbo(scanBasePackages = {"com.wecloud.im.**"})
@EnableAsync
@EnableScheduling
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableCaching
@EnableRocketMq
@MapperScan({"com.wecloud.**.mapper"})
@SpringBootApplication(scanBasePackages = {"com.wecloud"})
public class SpringBootPlusApplication {

    public static void main(String[] args) {
        //          logback 与nacos 自带的logback 冲突， nacos的logback 已经先于 项目启动，
        //        logback 本身 在命名之后不允许二次修改contextName的名字，问题在阿里nacos 官方git上已有人提出，
        //        https://github.com/alibaba/nacos/issues/1959
        System.setProperty("nacos.logging.default.config.enabled", "false");

        // 启动spring-boot-plus
        ConfigurableApplicationContext context = SpringApplication.run(SpringBootPlusApplication.class, args);
        // 打印项目信息
        PrintApplicationInfo.print(context);
        // 打印项目提示
        PrintApplicationInfo.printTip(context);
    }


}
