package com.wecloud.im.param;

import com.wecloud.dispatch.common.BaseRequest;
import com.wecloud.im.ws.model.request.PushVO;
import com.wecloud.utils.JsonUtils;

import javax.validation.constraints.NotNull;

/**
 * @Description 聊天内容
 * @Author lixiaozhong
 * @Date 2022/1/26 6:11 下午
 */
public class ChatContentVo extends BaseRequest {

    /**
     * 客户端请求id
     */
    String reqId;

    /**
     * 推送到通知栏对象
     */
    PushVO push;

    /**
     * 会话id
     */
    @NotNull
    Long toConversation;

    /**
     * 消息类型
     */
    @NotNull
    Integer type;

    /**
     * 发送文本
     */
    String text;

    /**
     * 被@人clientId， 多人用英文逗号分隔
     */
    String at;

    public PushVO getPush() {
        return JsonUtils.beanCopyDeep(this.get("push"), PushVO.class);
    }

    public void setPush(PushVO push) {
        this.push = push;
    }

    public Long getToConversation() {
        return Long.valueOf(this.get("toConversation") + "");
    }

    public void setToConversation(Long toConversation) {
        this.toConversation = toConversation;
    }

    public Integer getType() {
        return Integer.valueOf(this.get("type") + "");
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getText() {
        return this.get("type") + "";

    }

    public void setText(String text) {
        this.text = text;
    }

    public String getAt() {
        return at;
    }

    public void setAt(String at) {
        this.at = at;
    }

    @Override
    public String getReqId() {
        return reqId;
    }

    @Override
    public void setReqId(String reqId) {
        this.reqId = reqId;
    }
}
