package com.wecloud.im.event.listener;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import com.wecloud.im.event.ClientOnlineStatusChangeEvent;
import com.wecloud.im.service.ImCallbackService;

/**
 *
 * @Author luozh
 * @Date 2022年04月22日 09:47
 * @Version 1.0
 */
@Component
public class ClientOnlineStatusChangeListener implements ApplicationListener<ClientOnlineStatusChangeEvent> {

    @Autowired
    private ImCallbackService callbackService;

    @Override
    public void onApplicationEvent(ClientOnlineStatusChangeEvent event) {
        Long applicationId = event.getApplicationId();

        String clientId = event.getClientId();

        Integer status = event.getStatus();

        Integer deviceType = event.getDeviceType();

        Long time = event.getTime();

        String clientIp = event.getClientIp();

        callbackService.clientOnlineStatusChange(applicationId, clientId, status, deviceType, time, clientIp);
    }
}
