package com.wecloud.im.tillo.app_ws.sender;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.push.PushUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 异步系统推送
 */
@Component
@Slf4j
public class PushTask {


    /**
     * 异步系统推送
     *
     * @param imClientReceiver
     * @param imClientSender
     * @param imMessage
     */
    @Async
    public void push(ImClient imClientReceiver, ImClient imClientSender, ImMessage imMessage, ImApplication imApplication) {
        log.debug("push " + imClientReceiver.getClientId());


        // 校验参数
        if (imClientReceiver.getValid() == null || imClientReceiver.getDeviceToken() == null || imClientReceiver.getDeviceType() == null) {

            log.debug("push参数错误");
            return;
        }
        // 设备不想收到推送提醒, 1想, 0不想
        if (imClientReceiver.getValid() == 0) {
            return;
        }

        //  设备类型1:ios; 2:android
        if (imClientReceiver.getDeviceType() == 1) {
            ios(imClientReceiver, imApplication);

        } else {
            android(imClientReceiver, imApplication);
        }
    }

    private void android(ImClient imClientReceiver, ImApplication imApplication) {
        // 安卓推送通道,友盟:1;firebase:2; 信鸽3
        if (imApplication.getAndroidPushChannel() == 1) {
            log.debug("友盟");

            // 友盟推送
            PushUtils pushUtils = new PushUtils(imApplication.getUmengKey(), imApplication.getUmengSecret());

            // 安卓 单推
            String deviceTokenIOS = imClientReceiver.getDeviceToken();
            String titleIOS = "收到新消息";
            String subtitle = "";
            String body = "点击查看";
            try {
                pushUtils.sendIOSUnicast(deviceTokenIOS, titleIOS, subtitle, body);
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else if (imApplication.getAndroidPushChannel() == 2) {

            //firebase:2
            log.debug("firebase");


        } else if (imApplication.getAndroidPushChannel() == 3) {
            //  信鸽3
            log.debug("信鸽3");


        } else {
            log.debug("没有找到推送类型");
            return;
        }
    }

    private void ios(ImClient imClientReceiver, ImApplication imApplication) {
        // ios推送通道,友盟:1;firebase:2; apns原生:3
        if (imApplication.getIosPushChannel() == 1) {
            log.debug("友盟");

            // 友盟推送
            PushUtils pushUtils = new PushUtils(imApplication.getUmengKey(), imApplication.getUmengSecret());

            // 安卓单推
            String deviceToken = imClientReceiver.getDeviceToken();
            String unicastText = "Android unicast text";
            String unicastTicker = "点击查看";
            String title = "收到新消息";
            try {
                pushUtils.sendAndroidUnicast(deviceToken, unicastText, unicastTicker, title);
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else if (imApplication.getIosPushChannel() == 2) {

            //firebase:2
            log.debug("firebase");


        } else if (imApplication.getIosPushChannel() == 3) {
            //  apns原生:3
            log.debug("apns原生");


        } else {
            log.debug("没有找到推送类型");
            return;
        }
    }

}
