package com.wecloud.im.service;

import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.ImMessagePageParam;
import com.wecloud.im.param.ImMessageQueryVo;
import com.wecloud.im.vo.ImMessageOfflineListVo;
import com.wecloud.im.vo.OfflineMsgDto;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 消息存储表 服务类
 *
 * @author wei
 * @since 2021-04-29
 */
public interface ImMessageService extends BaseService<ImMessage> {

    /**
     * 保存
     *
     * @param imMessage
     * @return
     * @throws Exception
     */
    boolean saveImMessage(ImMessage imMessage) throws Exception;

        /**
         * 修改
         *
         * @param imMessage
         * @return
         * @throws Exception
         */
        boolean updateImMessage(ImMessage imMessage) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImMessage(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImMessageQueryVo getImMessageById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imMessagePageParam
     * @return
     * @throws Exception
     */
    Paging<ImMessageQueryVo> getImMessagePageList(ImMessagePageParam imMessagePageParam) throws Exception;

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param imHistoryMessagePageParam
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationId(ImHistoryMessagePageParam imHistoryMessagePageParam) throws Exception;


    /**
     * 查询用户所有离线消息
     *
     * @return
     * @throws Exception
     */
    List<ImMessageOfflineListVo> getOfflineList() throws Exception;


    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(Long clientId, Long conversationId);


    /**
     * 查询会话接收的最后一条消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    OfflineMsgDto getReceivedLastMsgByConversationId(Long clientId, Long conversationId);


    /**
     * 查询会话的最后一条消息
     *
     * @param conversationId
     * @return
     */
    OfflineMsgDto getLastMsgByConversationId(Long conversationId);


}
