package com.wecloud.im.controller;

import com.wecloud.im.param.add.ImClientDeviceInfoAdd;
import com.wecloud.im.service.ImClientService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端表 控制器
 *
 * @author wei
 * @since 2021-04-27
 */
@Slf4j
@RestController
@RequestMapping("/imClient")
@Api(value = "终端", tags = {"终端"})
public class ImClientController extends BaseController {

    @Autowired
    private ImClientService imClientService;

    /**
     * 添加或修改推送设备信息
     */
    @PostMapping("/addDeviceInfo")
    @OperationLog(name = "添加或修改推送设备信息", type = OperationLogType.ADD)
    @ApiOperation(value = "添加或修改推送设备信息(每次请求都会覆盖之前的数据)")
    public ApiResult<Boolean> addDeviceInfo(@Validated(Add.class) @RequestBody ImClientDeviceInfoAdd imClientDevice) throws Exception {
        boolean flag = imClientService.addDeviceInfo(imClientDevice);
        return ApiResult.result(flag);
    }

//    /**
//     * 添加终端表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加终端表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加终端表")
//    public ApiResult<Boolean> addImClient(@Validated(Add.class) @RequestBody ImClient imClient) throws Exception {
//        boolean flag = imClientService.saveImClient(imClient);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改终端表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改终端表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改终端表")
//    public ApiResult<Boolean> updateImClient(@Validated(Update.class) @RequestBody ImClient imClient) throws Exception {
//        boolean flag = imClientService.updateImClient(imClient);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除终端表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除终端表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除终端表")
//    public ApiResult<Boolean> deleteImClient(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imClientService.deleteImClient(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取终端表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "终端表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "终端表详情")
//    public ApiResult<ImClientQueryVo> getImClient(@PathVariable("id") Long id) throws Exception {
//        ImClientQueryVo imClientQueryVo = imClientService.getImClientById(id);
//        return ApiResult.ok(imClientQueryVo);
//    }
//
//    /**
//     * 终端表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "终端表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "终端表分页列表")
//    public ApiResult<Paging<ImClientQueryVo>> getImClientPageList(@Validated @RequestBody ImClientPageParam imClientPageParam) throws Exception {
//        Paging<ImClientQueryVo> paging = imClientService.getImClientPageList(imClientPageParam);
//        return ApiResult.ok(paging);
//    }

}

