package com.wecloud.im.ws.enums;

/**
 * @Description ws响应类型
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public enum WsResponseCmdEnum {

    /**
     * 下发在线多人音视频事件
     */
    MULTI_MEET_MSG(8),

    /**
     * 服务端下发通知型消息，例如：好友申请，好友认证结果.
     * 参数值参考{@link com.wecloud.im.enums.EventResponseSubCmdEnum EventResponseSubCmdEnum}
     */
    NOTICE_EVENT_MSG(7),

    /**
     * 服务端下发透传消息
     */
    REST_API_MSG(6),

    /**
     * 会话中的事件
     */
    CONVERSATION_EVENT_MSG(5),

    /**
     * 下发在线RTC事件
     */
    SINGLE_RTC_MSG(4),

    /**
     * 下发在线事件消息
     */
    ONLINE_EVENT_MSG(3),

    /**
     * 下发在线基本类型消息
     */
    ONLINE_MSG(2),

    /**
     * 响应数据类型
     */
    RES(1);


    private final int cmdCode;

    WsResponseCmdEnum(int uriCode) {
        this.cmdCode = uriCode;
    }


    public int getCmdCode() {
        return cmdCode;
    }
}
