package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 包机介绍 查询结果对象
 * </pre>
 *
 * @author giao
 * @date 2020-10-14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "CharterIntroductionQueryVo对象")
public class CharterIntroductionQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("商家ID")
    private Long mcId;

    @ApiModelProperty("私人包机图片url")
    private String imgUrlPrivate;

    @ApiModelProperty("私人包机文字")
    private String textPrivate;

    @ApiModelProperty("团体包机图片url")
    private String imgUrlTeam;

    @ApiModelProperty("团体包机文字")
    private String textTeam;

    @ApiModelProperty("货运包机图片url")
    private String imgUrlGoods;

    @ApiModelProperty("货运包机文字")
    private String textGoods;

    @ApiModelProperty("医疗包机图片url")
    private String imgUrlMedical;

    @ApiModelProperty("医疗包机文字")
    private String textMedical;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("内容")
    private String contents;

    @ApiModelProperty("状态，0-正常，1-取消，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;
}