package com.wecloud.im.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

/**
 * <pre>
 * 会话表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2021-05-07
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "MyConversationListVo")
public class MyConversationListVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会话id")
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("创建者客户端id")
    private String creator;

    @ApiModelProperty("可选	 对话的名字，可为群组命名。")
    private String name;

    @ApiModelProperty(value = "可选	自定义属性，供开发者扩展使用。", hidden = true)
    @JsonIgnore
    private String attribute;

    @ApiModelProperty("可选	自定义属性，供开发者扩展使用。")
    private HashMap attributes;

    @ApiModelProperty("可选	对话类型标志，是否是系统对话，后面会说明。")
    private Boolean system;

    @ApiModelProperty("未读消息条数")
    private Long msgNotReadCount;

    @ApiModelProperty("成员")
    private String members;

}