package com.wecloud.multimeet.service.impl;

import com.wecloud.im.ws.enums.WsMultiMeetResponseSubCmdEnum;
import com.wecloud.im.ws.enums.WsResponseCmdEnum;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.sender.ChannelSender;
import com.wecloud.multimeet.entity.response.MultiMeetInviteResponse;
import com.wecloud.multimeet.entity.response.MultiMeetRejectResponse;
import com.wecloud.multimeet.service.WsMultiMeetWrite;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author wenzhida
 * @Date 2022/3/7 22:26
 * @Description 多人音视频长连接下发
 */
@Service
public class WsMultiMeetWriteImpl implements WsMultiMeetWrite {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void invite(MultiMeetInviteResponse multiMeetInviteResponse, Long toClientId) {
        multiMeetInviteResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.INVITE.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetInviteResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetInviteResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }

    @Override
    public void reject(MultiMeetRejectResponse multiMeetRejectResponse, Long toClientId) {
        multiMeetRejectResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.REJECT.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetRejectResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetRejectResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toClientId);
    }


}
