package com.wecloud.im.controller;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.shiro.util.SecurityUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.SetConversationDoNotDisturbParam;
import com.wecloud.im.param.SetConversationTopParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.vo.ConversationMemberVo;

/**
 * 会话成员表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/imConversationMembers")
@Api(value = "会话成员表API", tags = {"会话成员表"})
public class ImConversationMembersController extends BaseController {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    /**
     * 添加或修改会话成员备注
     */
    @PostMapping("/updateClientRemarkName")
    @ApiOperation(value = "添加或修改会话成员备注", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateClientRemarkName(@RequestBody ImConvMemeClientRemarkNameParam imConvMemeClientRemarkNameParam) throws Exception {
        imConversationMembersService.saveOrUpdateClientRemarkName(imConvMemeClientRemarkNameParam);
        return ApiResult.ok();
    }


    /**
     * 添加或修改会话成员拓展字段
     */
    @PostMapping("/updateAttr")
    @ApiOperation(value = "添加或修改会话成员拓展字段", notes = "权限:目前只有client成员自己有权限操作")
    public ApiResult<Boolean> saveOrUpdateAttr(@RequestBody ImConversationMemAttrUpdate imConversationMemAttrUpdate) throws Exception {
        boolean r = imConversationMembersService.saveOrUpdateAttr(imConversationMemAttrUpdate);
        if (r) {
            return ApiResult.ok();
        } else {
            return ApiResult.fail();
        }
    }


    /**
     * 会话中成员表列表
     */
    @PostMapping("/getList")
    @ApiOperation(value = "获取会话中成员表列表")
    public ApiResult<List<ConversationMemberVo>> getImConversationMembersList(@Validated @RequestBody ListConversationMembersParam listConversationMembersParam) throws Exception {
//        Paging<ImConversationMembersQueryVo> paging = imConversationMembersService.getImConversationMembersPageList(imConversationMembersPageParam);
//        return ApiResult.ok(paging);
        return ApiResult.ok(imConversationMembersService.getImConversationMembersList(listConversationMembersParam));
    }

    /**
     * 会话置顶
     * @Author luozh
     * @Date 2022年04月26日 11:48:59
     * @param
     * @Return
     */
    @ApiOperation(value = "会话置顶")
    @PostMapping("/sdk/setTop")
    public ApiResult<Boolean> setTop(@RequestBody SetConversationTopParam param) {
        Long appId = SecurityUtils.getCurrentAppId();
        String clientId = param.getClientId();
        Long conversationId = param.getConversationId();
        Boolean top = param.getTop();
        imConversationMembersService.setTop(appId, clientId, conversationId, top);
        return ApiResult.ok();
    }

    /**
     * 设置免打扰
     * @Author luozh
     * @Date 2022年04月26日 11:49:55
     * @param
     * @Return
     */
    @ApiOperation(value = "会话免打扰")
    @PostMapping("/sdk/setDoNotDisturb")
    public ApiResult<Boolean> setDoNotDisturb(@RequestBody SetConversationDoNotDisturbParam param) {
        Long appId = SecurityUtils.getCurrentAppId();
        String clientId = param.getClientId();
        Long conversationId = param.getConversationId();
        Boolean doNotDisturb = param.getDoNotDisturb();
        imConversationMembersService.setDoNotDisturb(appId, clientId, conversationId, doNotDisturb);
        return ApiResult.ok();
    }

}

