package io.geekidea.springbootplus.framework.signature;

import lombok.Data;
import lombok.ToString;

import java.util.Set;

import javax.validation.constraints.NotBlank;

import org.springframework.boot.context.properties.ConfigurationProperties;

import com.google.common.collect.Sets;

/**
 * 签名头信息类
 * @Author linux
 * @Date 2021年01月20日 16:28
 * @Version 1.0
 */
@ConfigurationProperties(prefix = "can.signature")
@Signature
@Data
@ToString
public class SignatureHeaders {
    public static final String SIGNATURE_HEADERS_PREFIX = "can-signature-";

    public static final Set<String> SIGNATURE_HEADER_SET = Sets.newHashSet();

    private static final String HEADER_APP_ID = SIGNATURE_HEADERS_PREFIX + "appid";
    private static final String HEADER_TIMESTAMP = SIGNATURE_HEADERS_PREFIX + "timestamp";
    private static final String HEADER_NONCE = SIGNATURE_HEADERS_PREFIX + "nonce";
    private static final String HEADER_SIGNATURE = SIGNATURE_HEADERS_PREFIX + "signature";

    static {
        SIGNATURE_HEADER_SET.add(HEADER_APP_ID);
        SIGNATURE_HEADER_SET.add(HEADER_TIMESTAMP);
        SIGNATURE_HEADER_SET.add(HEADER_NONCE);
        SIGNATURE_HEADER_SET.add(HEADER_SIGNATURE);
    }

    /**
     * 线下分配的值
     * 客户端和服务端各自保存appId对应的appSecret
     */
    @NotBlank(message = "Header中缺少" + HEADER_APP_ID)
    @SignatureField
    private String appid;


    /**
     * 线下分配的值
     * 客户端和服务端各自保存，与appId对应
     */
    @SignatureField
    private String appsecret;

    /**
     * 时间戳，单位: ms
     */
    @NotBlank(message = "Header中缺少" + HEADER_TIMESTAMP)
    @SignatureField
    private String timestamp;

    /**
     * 流水号【防止重复提交】; (备注：针对查询接口，流水号只用于日志落地，便于后期日志核查； 针对办理类接口需校验流水号在有效期内的唯一性，以避免重复请求)
     */
    @NotBlank(message = "Header中缺少" + HEADER_NONCE)
    @SignatureField
    private String nonce;

    /**
     * 签名
     */
    @NotBlank(message = "Header中缺少" + HEADER_SIGNATURE)
    private String signature;

}
