package io.geekidea.springbootplus.framework.signature;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 签名注解
 * 指定哪些接口或者哪些实体需要签名
 * @Author linux
 * @Date 2021年01月20日 08:32:00
 * @Version 1.0
 */
@Target({TYPE, METHOD})
@Retention(RUNTIME)
@Documented
public @interface Signature {
    /**
     * 按照order值排序
     */
    String ORDER_SORT = "ORDER_SORT";
    /**
     * 字典序排序
     */
    String ALPHA_SORT = "ALPHA_SORT";

    boolean resubmit() default true;

    String sort() default Signature.ALPHA_SORT;
}
