package com.jumeirah.common.service;

import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.param.PlainTypePageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.vo.PlainTypeQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 飞机型号表 服务类
 *
 * @author wei
 * @since 2020-10-09
 */
public interface PlainTypeService extends BaseService<PlainType> {

    /**
     * 保存
     *
     * @param plainType
     * @return
     * @throws Exception
     */
    boolean savePlainType(PlainType plainType) throws Exception;

    /**
     * 修改
     *
     * @param plainType
     * @return
     * @throws Exception
     */
    boolean updatePlainType(PlainType plainType) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deletePlainType(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    PlainTypeQueryVo getPlainTypeById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param plainTypePageParam
     * @return
     * @throws Exception
     */
    Paging<PlainTypeQueryVo> getPlainTypePageList(PlainTypePageParam plainTypePageParam) throws Exception;

    /**
     *  获取所有飞机类型
     * @return
     */
    List<PlainType> getAllMap();

    /**
     * 飞机型号表分页列表
     * @return
     */
    List<PlainType> getAppPlainTypePageList();

}
