package com.wecloud.im.sdk.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wecloud.im.sdk.common.HttpMethod;
import com.wecloud.im.sdk.common.RequestMessage;
import com.wecloud.im.sdk.model.ClientLoginRequest;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.RegisterClientRequest;
import com.wecloud.im.sdk.model.Token;

import static com.wecloud.im.sdk.ResourcePathConstants.GET_TOKEN_URL;
import static com.wecloud.im.sdk.ResourcePathConstants.REGISTER_CLIENT_URL;
import static com.wecloud.im.sdk.utils.CodingUtils.assertParameterNotNull;

/**
 * client
 * @Author luozh
 * @Date 2022年04月13日 15:26
 * @Version 1.0
 */
public class WecloudImClientOperation extends WecloudImOperation {

    public WecloudImClientOperation(URL apiDomain, String appKey, String appSecret) {
        super(apiDomain, appKey, appSecret);
    }

    /**
     * 注册客户端
     * @Author luozh
     * @Date 2022年04月13日 03:38:58
     * @param registerClientRequest
     * @Return
     */
    public ImClient registerClient(RegisterClientRequest registerClientRequest) {
        Long userId = registerClientRequest.getUserId();
        // 参数校验
        assertParameterNotNull(userId, "userId");
        // 校验通过 构建参数
        Map<String, String> param = new HashMap<>();
        param.put("appKey", appKey);
        param.put("userId", registerClientRequest.getUserId() + "");
        param.put("headPortrait", registerClientRequest.getHeadPortrait());
        param.put("nickname", registerClientRequest.getNickname());
        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(REGISTER_CLIENT_URL)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(registerClientRequest).build();

        JSONObject result = doOperation(request);
        ImClient imClient = JSON.parseObject(result.toJSONString(), ImClient.class);
        return imClient;
    }

    /**
     * 获取用户token
     * @Author luozh
     * @Date 2022年04月18日 11:52:18
     * @param clientLoginRequest
     * @Return
     */
    public Token getToken(ClientLoginRequest clientLoginRequest) {
        Long clientId = clientLoginRequest.getClientId();
        Integer deviceType = clientLoginRequest.getDeviceType();
        // 参数校验
        assertParameterNotNull(clientId, "userId");
        assertParameterNotNull(deviceType, "deviceType");
        // 校验通过 构建参数
        Map<String, String> param = new HashMap<>();
        param.put("deviceType", clientLoginRequest.getDeviceType() + "");
        param.put("clientId", clientLoginRequest.getClientId() + "");

        // 发送请求
        RequestMessage request = new WecloudRequestMessageBuilder().setEndpoint(GET_TOKEN_URL)
                .setMethod(HttpMethod.POST).setParameters(param)
                .setOriginalRequest(clientLoginRequest).build();

        JSONObject result = doOperation(request);
        Token token = JSON.parseObject(result.toJSONString(), Token.class);
        return token;


    }
}
