package com.wecloud.im.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImRtcRecord;
import com.wecloud.im.param.rtc.CreateRtcChannelParam;
import com.wecloud.im.param.rtc.RtcRecordParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;

/**
 * @Author wenzhida
 * @Date 2022/3/16 9:08
 * @Description 单人音视频房记录服务接口
 */
public interface ImRtcRecordService extends BaseService<ImRtcRecord> {

    /**
     * 创建rtc通话记录
     * @param param
     * @param channelId
     */
    void createRtcRecord(CreateRtcChannelParam param, Long channelId, ImClient currentClient);

    /**
     * 更新音视频记录
     * @param channelId
     * @param type 1-同意进入频道  2-拒接进入频道  3-主动挂断(离开频道)
     */
    void updateRtcRecord(Long channelId, Integer type);


    /**
     * 获取通话记录
     */
    Page<ImRtcRecord> getPageImRtcRecords(RtcRecordParam rtcRecordParam);
}
