package com.wecloud.im.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * ImMsgReadUpdate
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMsgReceivedStatusUpdate")
public class ImMsgReceivedStatusUpdate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "消息id数组,可以传入单个或多个, 如接收离线消息列表时可以批量修改 则传入多个", required = true)
    @NotEmpty(message = "msgIds==null")
    private List<Long> msgIds;

    @ApiModelProperty(value = "是否同时修改为已读状态", required = false)
    private Boolean readStatus = false;
}
