package com.wecloud.im.tillo.app_ws.model;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wjm
 * @Description 常量
 * @date 2018/12/20
 */
@Slf4j
public class Constants {


    /*
     * 当前服务器cpu核心数量（）
     */
    public static final Integer CPU_PROCESSORS = Runtime.getRuntime().availableProcessors();

    static {

        log.info("CPU_PROCESSORS:" + CPU_PROCESSORS);
    }

    /**
     * 加密消息
     */
    public static final Integer IS_CRYPTO_MESSAGE = 1;

    /**
     * 加密消息类型
     */
    public static final Integer CRYPTO_TYPE = 3;

    /**
     * 网页版长连接url
     */
    public static final String WEB_WS_URL = "/webws";

    /**
     * WEBWS_V_2
     */
    public static final String WEBWS_V_2 = "/webwsV2";

    /**
     * app长连接url
     */
    public static final String APP_WS_URL = "/appws";

    /**
     * 存储当前登录用户id的字段名
     */
    public static final String CURRENT_USER_ID = "CURRENT_USER_ID";

    /**
     * token有效期（小时）30天
     */
    public static final int TOKEN_EXPIRES_HOUR = 720;

    /**
     * token
     */
    public static final String TOKEN = "token";

    /**
     * 密码加密盐
     */
    public static final String SALT = "tillo2018";

    /**
     * http字符传
     */
    public static final String HTTP = "http";

    /**
     * 标点符号--逗号
     */
    public static final String COMMA = ",";

    /**
     * 标点符号--百分号
     */
    public static final String PERCENT = "%";

    /**
     * 标点符号--问号
     */
    public static final String MARK = "?";

    /**
     * 群聊取模数
     */
    public static final Integer GROUP_MODULUS = 32;

    /**
     * 字符串0
     */
    public static final String ZERO = "0";

    /**
     * 横线
     */
    public static final String LINE = "-";


}
