package io.geekidea.springbootplus.test;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.tillo.app_ws.utils.RedisUtils;
import io.geekidea.springbootplus.framework.shiro.util.JwtUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.Duration;

/**
 * 生成测试appkey与appSecret对,并存入数据库
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class LoginTest {

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private StringRedisTemplate redisTemplate;


    @Autowired
    private ImApplicationService imApplicationService;


    @Autowired
    private ImClientService imClientService;

    private String getToken(String timestemp, String clientId, String appKey, String sign) throws Exception {

        String token = null;

        //  从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOne(
                new QueryWrapper<ImApplication>().lambda().eq(ImApplication::getAppKey, appKey)
        );

        // 验证签名
        String mySign = new MD5().digestHex(timestemp + clientId + imApplication.getAppKey() + imApplication.getAppSecret());

        if (mySign.equals(sign)) {
            System.out.println("一致" + mySign);
        } else {
            System.out.println("不一致" + mySign);
        }

        // 判断client是否存在
        ImClient byid = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, imApplication.getId())
                .eq(ImClient::getClientId, clientId));

        if (byid == null) {
            System.out.println("不存在");

            ImClient imClient = new ImClient();
            imClient.setId(new Snowflake(1L, 1L).nextId());
            imClient.setFkAppid(imApplication.getId());
            imClient.setClientId(clientId);
            imClientService.save(imClient);

        } else {
            System.out.println("存在");
        }

        String generateToken = JwtUtil.generateToken(clientId, imApplication.getAppSecret(), Duration.ofDays(100));

        redisTemplate.opsForValue().set("client:" + imApplication.getAppKey() + ":" + clientId, generateToken);
        return generateToken;
    }

    @Test
    public void test() throws Exception {
        // 时间戳
        String timestemp = "1619574452548";
        String clientId = "c1";
        String appKey = "elLwpel1gWCHDqZy";
        String sign = "b240f069db255eaa0ab4677016c86f71";
        String token = getToken(timestemp, clientId, appKey, sign);
        System.out.println("token:" + token);
    }
}
