package com.wecloud.im.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * @Author wenzhida
 * @Date 2022/2/17 15:58
 * @Description 群禁言入参
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "群禁言入参")
public class MutedGroupParam extends BaseEntity {

    private static final long serialVersionUID = -6974569111928946842L;

    @NotNull
    @ApiModelProperty("会话id")
    private Long conversationId;

    /**
     * 禁言类型
     * @see com.wecloud.im.sdk.enums.MutedEnum
     */
    @NotNull
    @ApiModelProperty("禁言类型 1-取消禁言 2-禁言")
    private Integer mutedType;

}
