package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.CharterIntroduction;
import com.jumeirah.common.mapper.CharterIntroductionMapper;
import com.jumeirah.common.param.CharterIntroductionPageParam;
import com.jumeirah.common.service.CharterIntroductionService;
import com.jumeirah.common.vo.CharterIntroductionQueryForAppVo;
import com.jumeirah.common.vo.CharterIntroductionQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 包机介绍 服务实现类
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@Service
public class CharterIntroductionServiceImpl extends BaseServiceImpl<CharterIntroductionMapper, CharterIntroduction> implements CharterIntroductionService {

    @Autowired
    private CharterIntroductionMapper charterIntroductionMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveCharterIntroduction(CharterIntroduction charterIntroduction) throws Exception {
        return super.save(charterIntroduction);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCharterIntroduction(CharterIntroduction charterIntroduction) throws Exception {
        return super.updateById(charterIntroduction);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteCharterIntroduction(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public CharterIntroductionQueryVo getCharterIntroductionById(Long id) throws Exception {
        return charterIntroductionMapper.getCharterIntroductionById(id);
    }

    @Override
    public Paging<CharterIntroductionQueryVo> getCharterIntroductionPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
        Page<CharterIntroductionQueryVo> page = new PageInfo<>(charterIntroductionPageParam, OrderItem.desc(getLambdaColumn(CharterIntroduction::getCreateTime)));
        IPage<CharterIntroductionQueryVo> iPage = charterIntroductionMapper.getCharterIntroductionPageList(page, charterIntroductionPageParam);
        return new Paging<CharterIntroductionQueryVo>(iPage);
    }

    @Override
    public Paging<CharterIntroductionQueryForAppVo> getCharterIntroductionForAppPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception {
        Page<CharterIntroductionQueryForAppVo> page = new PageInfo<>(charterIntroductionPageParam, OrderItem.desc("ci.create_time"));
        IPage<CharterIntroductionQueryForAppVo> iPage = charterIntroductionMapper.getCharterIntroductionForAppPageList(page, charterIntroductionPageParam);
        return new Paging<>(iPage);
    }

}
