/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.geekidea.springbootplus.test;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.wecloud.im.register.GetIpUtils;
import io.geekidea.springbootplus.SpringBootPlusApplication;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Map;

/**
 * get  ip
 **/
@RunWith(SpringRunner.class)
@SpringBootTest(classes = SpringBootPlusApplication.class)
public class GetIpTest {
    @Autowired
    private GetIpUtils publicIpUtils;

    @Value("${spring.cloud.nacos.discovery.server-addr}")
    private String addr;


    @Test
    public void test() throws NacosException {

//        String s = publicIpUtils.getlanIp();
//        String publicIp = publicIpUtils.getPublicIp();
//        String s2 = publicIpUtils.getlanIp();
//        String publicIp2 = publicIpUtils.getPublicIp();

//        String serveAddr = System.getProperty("serveAddr");
        NamingService naming = NamingFactory.createNamingService(addr);
        Instance wecloudIm = naming.selectOneHealthyInstance("wecloud_im");
        Map<String, String> metadata = wecloudIm.getMetadata();
        String publicIp = metadata.get("ip.netty.public");
        System.out.println(wecloudIm);

//        naming.subscribe("ip.netty.public", event -> {
//            if (event instanceof NamingEvent) {
//                System.out.println(((NamingEvent) event).getServiceName());
//                System.out.println(((NamingEvent) event).getInstances());
//            }
//        });

//        while (true){
//
//        }

    }


}
