package com.wecloud.im.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/15 13:57
 * @Description 与client关系枚举
 */
public enum RelationEnum implements BaseEnum {

    /**
     * 1-陌生人
     */
    STRANGER(1, "陌生人"),

    /**
     * 2-好友
     */
    FRIEND(2, "好友"),

    /**
     * 3-被我拉黑
     */
    BE_BLACK(3, "被我拉黑");

    RelationEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
