package io.geekidea.springbootplus.framework.signature;

import lombok.Data;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * Jwt参数配置
 * @Author linux
 * @Date 2020年12月28日 11:25:17
 * @Version 1.0
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "signature")
public class SignatureProperties {

	/**
	 * appSecret
	 */
	private String appId;

	/**
	 * appSecret
	 */
	private String appSecret;

	/**
	 * 同一个nonce 请求多长时间内不允许重复请求 单位：秒
	 */
	private Long expireTime;

	/**
	 * 同一个请求多长时间内有效 单位：秒
	 */
	private Long resubmitDuration;

}
