-- 在feature-cluster 2021年12月22日之后，需要执行的的sql增量脚本
ALTER TABLE `im_conversation` CHANGE COLUMN `system` `system_flag` tinyint(1) NULL DEFAULT NULL COMMENT '可选	对话类型标志，是否是系统对话，后面会说明。' AFTER `attributes`;
ALTER TABLE `im_message` CHANGE COLUMN `system` `system_flag` tinyint(1) NULL DEFAULT 0 COMMENT '0非系统通知; 1为系统通知' AFTER `event`;
-- 在feature-cluster 2022年1月4日之后，需要执行的sql增量脚本
ALTER TABLE im_conversation
    ADD COLUMN`member_count` int NULL COMMENT '群成员数' AFTER`last_message`;

ALTER TABLE im_conversation
    ADD COLUMN`chat_type` tinyint NULL COMMENT '是否万人群' AFTER`member_count`;

ALTER TABLE `im_conversation_members`
    ADD INDEX `fk_client_id`(`fk_client_id`);

-- 在feature-cluster 2022年1月10日之后，需要执行的sql增量脚本
-- 消息最新已读寻址表
CREATE TABLE `im_msg_read_lastest`
(
    `id`                 bigint NOT NULL COMMENT '收件id',
    `create_time`        timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`        timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    `read_time`          timestamp NULL DEFAULT NULL COMMENT '读取时间',
    `receive_time`       timestamp NULL DEFAULT NULL COMMENT '接收时间',
    `fk_appid`           bigint NOT NULL COMMENT '应用appid',
    `fk_client_id`       bigint NOT NULL COMMENT '接收客户端id',
    `fk_conversation_id` bigint NOT NULL COMMENT '会话id',
    `fk_receive_msg_id`  bigint DEFAULT NULL COMMENT '最后一条已接收的消息id',
    `fk_read_msg_id`     bigint DEFAULT NULL COMMENT '最后一条已读的消息id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `receiver_conversation`(`fk_client_id`,`fk_conversation_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='消息最新已读寻址表';


CREATE TABLE `im_friend`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `client_id`         varchar(32)  NOT NULL COMMENT '自己id',
    `client_id_friend`  varchar(32)  NOT NULL COMMENT '好友id',
    `client_id_claimer` varchar(32)  NOT NULL COMMENT '好友申请者',
    `friend_name`          varchar(255)     DEFAULT NULL COMMENT '好友名称备注',
    `reject_remark`        varchar(255)     DEFAULT NULL COMMENT '拒绝说明',
    `request_remark`       varchar(255)     DEFAULT NULL COMMENT '好友请求说明',
    `state`                tinyint NOT NULL DEFAULT '0' COMMENT '好友状态，1：待确定，2：已确认，3：已拒绝，4：已删除',
    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `friend_id`(`client_id`,`client_id_friend`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='好友表';

CREATE TABLE `im_friend_recommend`
(
    `id`                  bigint(20) NOT NULL COMMENT '主键id',
    `client_id`        varchar(32) NOT NULL COMMENT '自己id',
    `client_id_friend` varchar(32) NOT NULL COMMENT '好友id',
    `source`              tinyint         DEFAULT NULL COMMENT '推荐来源',
    `del_flag`            bit(1) NOT NULL default 0 COMMENT '删除标识',
    `create_time`         timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`         timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `friend_id`(client_id, client_id_friend) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='好友表';


-- 2022年01月21日17:31:16  何威 将type参数上移一层
ALTER TABLE `im_message`
    ADD COLUMN`msg_type` int(2) NULL DEFAULT NULL COMMENT '消息类型' AFTER`send_status`;

-- by wenzhida 消息删除、群管理、群禁言管理
ALTER TABLE im_message ADD COLUMN is_delete tinyint NOT NULL DEFAULT '1' COMMENT '是否删除 1-未删除 2-删除';

ALTER TABLE im_conversation_members ADD COLUMN role tinyint NOT NULL DEFAULT '1' COMMENT '角色 1-普通群成员 2-管理员 3-群主';

ALTER TABLE im_conversation ADD COLUMN muted tinyint NOT NULL DEFAULT '1' COMMENT '禁言开关 1-未禁言 2-禁言';

ALTER TABLE im_conversation_members ADD COLUMN muted tinyint NOT NULL DEFAULT '1' COMMENT '禁言开关 1-未禁言 2-禁言';

ALTER TABLE im_conversation_members ADD COLUMN `client_id` varchar(200) DEFAULT NULL COMMENT '客户方提供的唯一id';

ALTER TABLE im_client_blacklist CHANGE fk_client_id_prevent client_id_prevent varchar(32) DEFAULT NULL COMMENT '拉黑者';
ALTER TABLE im_client_blacklist CHANGE fk_client_id_be_prevent client_id_be_prevent varchar(32) DEFAULT NULL COMMENT '被拉黑';

ALTER TABLE im_client ADD COLUMN `platform` int DEFAULT NULL COMMENT '平台编码：客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs';

CREATE TABLE `im_user`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `id_number`           varchar(32)  NOT NULL COMMENT '蓝豆号',
    `phone`             varchar(32)     DEFAULT NULL COMMENT '手机号码',
    `id_card_no`             varchar(32)     DEFAULT NULL COMMENT '身份证号码',
    `email`             varchar(32)     DEFAULT NULL COMMENT '邮箱号码',
    `password`             varchar(32)     DEFAULT NULL COMMENT '密码',
    `sex`               tinyint DEFAULT 3 COMMENT '性别 1-男 2-女 3-未知',
    `head_portrait`     varchar(1000) DEFAULT NULL COMMENT '头像',
    `nickname`          varchar(30) DEFAULT NULL COMMENT '昵称',
    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `phone` (`phone`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户表';


-- 20220302 by wenzhida

CREATE TABLE `im_client_device`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `fk_appid`              bigint DEFAULT NULL COMMENT '应用appid',
    `fk_client_id`         bigint NOT NULL COMMENT '客户端id',
    `valid`                 int DEFAULT NULL COMMENT '设备不想收到推送提醒',
    `device_type`           int DEFAULT NULL COMMENT '设备类型1:ios; 2:android',
    `device_token`          varchar(300) DEFAULT NULL COMMENT '设备推送token',
    `unique_device_id`          varchar(50) DEFAULT NULL COMMENT '设备唯一id(由设备端生成)',
    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_fk_client_id` (`fk_client_id`) USING BTREE,
    KEY `idx_device_token_appid` (`device_token`,`fk_appid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='客户端设备表';


-- 20220315 by wenzhida

DROP TABLE IF EXISTS `im_multi_rtc_room`;
CREATE TABLE `im_multi_rtc_room`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `fk_appid`              bigint DEFAULT NULL COMMENT '应用appid',
    `room_id`               varchar(64) DEFAULT NULL COMMENT '房间id(live kit提供)',
    `state`                tinyint NOT NULL DEFAULT '1' COMMENT '房间状态，1：已创建，2：会议中，3：会议结束',
    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_room_id` (`room_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='多人音视频房间表';


DROP TABLE IF EXISTS `im_multi_rtc_room_member`;
CREATE TABLE `im_multi_rtc_room_member`
(
    `id`             bigint    NOT NULL COMMENT '主键id',
    `fk_rtc_room_id` bigint    NOT NULL COMMENT 'im房间id',
    `room_id`        varchar(64)        DEFAULT NULL COMMENT '房间id(live kit提供)',
    `fk_client_id`   bigint    NOT NULL COMMENT 'client主键id',
    `client_id`      varchar(200)       DEFAULT NULL COMMENT '客户方提供的唯一id',
    `state`          tinyint   NOT NULL DEFAULT '1' COMMENT '房间成员状态，1：呼叫中，2：已接听，3：已拒绝，4：未接听，5：已断开',
    `call_time`      timestamp NULL     DEFAULT NULL COMMENT '呼叫时间',
    `heartbeat_time` timestamp NULL     DEFAULT NULL COMMENT '心跳时间',
    `create_time`    timestamp NULL     DEFAULT NULL COMMENT '创建时间',
    `update_time`    timestamp NULL     DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_fk_rtc_room_id` (`fk_rtc_room_id`) USING BTREE,
    KEY `idx_room_id` (`room_id`) USING BTREE,
    KEY `idx_call_time_state` (`call_time`, `state`) USING BTREE,
    KEY `idx_heartbeat_time_state` (`heartbeat_time`, `state`) USING BTREE,
    KEY `idx_client_id` (`client_id`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='多人音视频房间成员表';


ALTER TABLE im_conversation
    ADD COLUMN head_portrait varchar(1000) DEFAULT NULL COMMENT '群头像';


ALTER TABLE im_message
    ADD COLUMN receivers varchar(200) DEFAULT NULL COMMENT '接收人,多人用英文逗号分隔-群内指定人员可见场景';



DROP TABLE IF EXISTS `im_rtc_record`;
CREATE TABLE `im_rtc_record`
(
    `id`                   bigint  NOT NULL COMMENT '主键id',
    `fk_appid`              bigint DEFAULT NULL COMMENT '应用appid',
    `channel_id`            bigint DEFAULT NULL COMMENT '频道id',
    `from_client_id`        varchar(200)       DEFAULT NULL COMMENT '发起方clientId',
    `to_client_id`        varchar(200)       DEFAULT NULL COMMENT '接收方clientId',
    `state`                tinyint NOT NULL DEFAULT '1' COMMENT '频道状态，1：音视频发起，2：音视频中，3：音视频结束',
    `call_type`                tinyint NOT NULL DEFAULT '1' COMMENT '音视频类型: 1-video或2-voice',
    `start_time`          timestamp NULL DEFAULT NULL COMMENT '音视频开始时间',
    `end_time`          timestamp NULL DEFAULT NULL COMMENT '音视频结束时间',

    `create_time`          timestamp NULL DEFAULT NULL COMMENT '创建时间',
    `update_time`          timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
    PRIMARY KEY (`id`) USING BTREE,
    KEY `idx_channel_id` (`channel_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='单人音视频聊天记录表';


ALTER TABLE im_conversation
    ADD COLUMN `is_encrypt` tinyint(1) unsigned DEFAULT '0' COMMENT '是否加密聊天： 1-是 0-否';


