package com.wecloud.im.user.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/23 15:20
 * @Description 修改昵称入参
 */
@Data
public class ModifyNicknameParam implements Serializable {

    private static final long serialVersionUID = -4266385433321572881L;

    /**
     * userId
     */
    @NotNull(message = "userId不可为空")
    @ApiModelProperty("userId")
    private Long userId;

    /**
     * 昵称
     */
    @NotNull(message = "昵称不能为空")
    @ApiModelProperty("昵称")
    private String nickname;

}
