package com.wecloud.im.router;

import com.wecloud.im.ws.sender.ChannelSender;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@DubboService
public class RouterSendServiceImpl implements RouterSendService {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void sendMsgRemote(Long clientId, Integer platform, String msg) {
        channelSender.sendMsgLocal(clientId, platform, msg);
    }

    @Override
    public void batchSendMsgRemote(List<String> sendRouterKeys, String msg) {
        channelSender.batchSendMsgLocal(sendRouterKeys, msg);
    }
}
