package com.wecloud.im.controller;

import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.service.ImInboxService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消息收件箱表 控制器
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@RestController
@RequestMapping("/imInbox")
@Api(value = "消息收件箱表API", tags = {"消息收件箱表"})
public class ImInboxController extends BaseController {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @PostMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public ApiResult<Boolean> updateImMsgReceived(@RequestBody @Validated ImMsgReceivedStatusUpdate imMsgReceivedUpdate) throws Exception {
        return imInboxService.updateImMsgReceived(imMsgReceivedUpdate);
    }

    /**
     * 消息修改为已读状态
     */
    @PostMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public ApiResult<Boolean> updateInMsgReadUpdate(@RequestBody MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws Exception {
        if (CollectionUtils.isEmpty(msgReadStatusUpdateParam.getMsgIds())) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return imInboxService.updateImMsgRead(msgReadStatusUpdateParam);
    }

    /**
     * 整个会话消息修改为已读状态
     */
    @PostMapping("/updateMsgReadStatusByConversation")
    @ApiOperation(value = "整个会话消息修改为已读状态")
    public ApiResult<Boolean> updateMsgReadStatusByConversation(@RequestBody MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws Exception {
        if (msgReadStatusUpdateParam.getConversationId() == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return ApiResult.ok(imInboxService.updateMsgReadStatusByConversation(msgReadStatusUpdateParam));
    }

}

