package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.MerchantRole;
import com.jumeirah.common.param.MerchantRolePageParam;
import com.jumeirah.common.vo.MerchantRoleQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 商家角色 Mapper 接口
 *
 * @author wei
 * @since 2020-09-28
 */
@Repository
public interface MerchantRoleMapper extends BaseMapper<MerchantRole> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        MerchantRoleQueryVo getMerchantRoleById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param merchantRolePageParam
             * @return
             */
            IPage<MerchantRoleQueryVo> getMerchantRolePageList(@Param("page") Page page,@Param("param") MerchantRolePageParam merchantRolePageParam);

        }
