package com.wecloud.im.action;

import com.alibaba.fastjson.JSON;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.ws.model.WsResponse;

/**
 * @Author luozh
 * @Date 2022年04月02日 16:39
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/inbox")
@Api(value = "ws-消息收件箱API", tags = {"ws-消息收件箱"})
public class InboxAction {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @ActionMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public WsResponse<Map<String, Boolean>> updateImMsgReceived(@Validated ImMsgReceivedStatusUpdate data) throws Exception {
        log.info("消息修改为已接收状态入参 {}", JSON.toJSONString(data));
        imInboxService.updateImMsgReceived(data);
        return WsResponse.ok();
    }

    /**
     * 消息修改为已读状态
     */
    @ActionMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public WsResponse<Map<String, Boolean>> updateInMsgReadUpdate(MsgReadStatusUpdateParam data) throws Exception {
        log.info("消息修改为已读状态入参 {}", JSON.toJSONString(data));
        if (CollectionUtils.isEmpty(data.getMsgIds())) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        imInboxService.updateImMsgRead(data);
        return WsResponse.ok();
    }

    /**
     * 会话消息修改为已读状态
     * @return
     */
    @ActionMapping("/updateMsgReadStatusByConversation")
    @ApiOperation(value = "会话消息修改为已读状态")
    public WsResponse<Map<String, Boolean>> updateMsgReadStatusByConversation(UpdateMsgReadStatusByConversationParam data) throws Exception {
        log.info("会话消息修改为已读状态入参 {}", JSON.toJSONString(data));
        if (data.getConversationId() == null) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        boolean r = imInboxService.updateMsgReadStatusByConversation(data);
        Map<String, Boolean> result = new HashMap<>();
        result.put("result", r);
        return WsResponse.ok(result);
    }
}
