package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.mapper.ImInboxMapper;
import com.wecloud.im.param.ImInboxPageParam;
import com.wecloud.im.param.ImInboxQueryVo;
import com.wecloud.im.param.ImMsgReceivedUpdate;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImInboxService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 消息收件箱表 服务实现类
 *
 * @author wei
 * @since 2021-05-06
 */
@Slf4j
@Service
public class ImInboxServiceImpl extends BaseServiceImpl<ImInboxMapper, ImInbox> implements ImInboxService {

    @Autowired
    private ImInboxMapper imInboxMapper;
    @Autowired
    private ImClientService imClientService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveImInbox(ImInbox imInbox) throws Exception {
        return super.save(imInbox);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateImInbox(ImInbox imInbox) throws Exception {
        return super.updateById(imInbox);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteImInbox(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public ImInboxQueryVo getImInboxById(Long id) throws Exception {
        return imInboxMapper.getImInboxById(id);
    }

    @Override
    public Paging<ImInboxQueryVo> getImInboxPageList(ImInboxPageParam imInboxPageParam) throws Exception {
        Page<ImInboxQueryVo> page = new PageInfo<>(imInboxPageParam, OrderItem.desc(getLambdaColumn(ImInbox::getCreateTime)));
        IPage<ImInboxQueryVo> iPage = imInboxMapper.getImInboxPageList(page, imInboxPageParam);
        return new Paging<ImInboxQueryVo>(iPage);
    }

    @Override
    public ApiResult<Boolean> updateImMsgReceived(ImMsgReceivedUpdate imMsgReceivedUpdate) {
        ImClient client = imClientService.getClient();

        Long aLong = imInboxMapper.updateImMsgReceivedByIds(client.getId(), imMsgReceivedUpdate.getMsgIds());

        return ApiResult.ok();
    }

}
