package com.wecloud.im.service;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.param.ImApplicationPageParam;
import com.wecloud.im.param.ImApplicationQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 第三方应用表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImApplicationService extends BaseService<ImApplication> {

    /**
     * 保存
     *
     * @param imApplication
     * @return
     * @throws Exception
     */
    boolean saveImApplication(ImApplication imApplication) throws Exception;

    /**
     * 修改
     *
     * @param imApplication
     * @return
     * @throws Exception
     */
    boolean updateImApplication(ImApplication imApplication) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImApplication(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImApplicationQueryVo getImApplicationById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imApplicationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImApplicationQueryVo> getImApplicationPageList(ImApplicationPageParam imApplicationPageParam) throws Exception;

}
