package com.jumeirah.common.service;

import com.jumeirah.common.entity.MerchantPermission;
import com.jumeirah.common.param.MerchantPermissionPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.vo.MerchantPermissionQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 商家权限 服务类
 *
 * @author wei
 * @since 2020-09-28
 */
public interface MerchantPermissionService extends BaseService<MerchantPermission> {

        /**
         * 保存
         *
         * @param merchantPermission
         * @return
         * @throws Exception
         */
        boolean saveMerchantPermission(MerchantPermission merchantPermission)throws Exception;

        /**
         * 修改
         *
         * @param merchantPermission
         * @return
         * @throws Exception
         */
        boolean updateMerchantPermission(MerchantPermission merchantPermission)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteMerchantPermission(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        MerchantPermissionQueryVo getMerchantPermissionById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param merchantPermissionPageParam
         * @return
         * @throws Exception
         */
        Paging<MerchantPermissionQueryVo> getMerchantPermissionPageList(MerchantPermissionPageParam merchantPermissionPageParam) throws Exception;

        }
