/*
 * Decompiled with CFR 0.152.
 */
package com.wecloud.classencrypt;

import com.wecloud.classencrypt.AgentTransformer;
import com.wecloud.classencrypt.Const;
import com.wecloud.classencrypt.InputForm;
import com.wecloud.classencrypt.JarDecryptor;
import com.wecloud.classencrypt.util.CmdLineOption;
import com.wecloud.classencrypt.util.EncryptUtils;
import com.wecloud.classencrypt.util.IoUtils;
import com.wecloud.classencrypt.util.JarUtils;
import com.wecloud.classencrypt.util.Log;
import com.wecloud.classencrypt.util.StrUtils;
import java.io.Console;
import java.io.File;
import java.lang.instrument.Instrumentation;

public class CoreAgent {
    public static void premain(String args, Instrumentation inst) {
        byte[] passHash;
        String pwdname;
        Const.pringInfo();
        CmdLineOption options = new CmdLineOption();
        options.addOption("pwd", true, "\u5bc6\u7801");
        options.addOption("pwdname", true, "\u73af\u5883\u53d8\u91cf\u5bc6\u7801\u53c2\u6570\u540d");
        options.addOption("nopwd", false, "\u65e0\u5bc6\u7801\u542f\u52a8");
        options.addOption("debug", false, "\u8c03\u8bd5\u6a21\u5f0f");
        options.addOption("del", true, "\u8bfb\u53d6\u5bc6\u7801\u540e\u5220\u9664\u5bc6\u7801");
        char[] pwd = JarDecryptor.readPassFromJar(new File(JarUtils.getRootPath(null)));
        if (args != null) {
            options.parse(args.split(" "));
            Const.DEBUG = options.hasOption("debug");
        }
        if (options.hasOption("nopwd")) {
            pwd = new char[]{'#'};
        }
        if (StrUtils.isEmpty(pwd)) {
            pwd = options.getOptionValue("pwd", "").toCharArray();
        }
        if (StrUtils.isEmpty(pwd) && StrUtils.isNotEmpty(pwdname = options.getOptionValue("pwdname"))) {
            String p = System.getenv(pwdname);
            char[] cArray = pwd = p == null ? null : p.toCharArray();
        }
        if (StrUtils.isEmpty(pwd)) {
            Log.debug("\u65e0\u6cd5\u4eceGUI\u4e2d\u83b7\u53d6\u5bc6\u7801\uff0c\u8bfb\u53d6\u5bc6\u7801\u6587\u4ef6");
            pwd = CoreAgent.readPasswordFromFile(options);
        }
        if (StrUtils.isEmpty(pwd)) {
            Log.debug("\u65e0\u6cd5\u5728\u53c2\u6570\u4e2d\u83b7\u53d6\u5bc6\u7801\uff0c\u4ece\u63a7\u5236\u53f0\u83b7\u53d6");
            Console console = System.console();
            if (console != null) {
                Log.debug("\u63a7\u5236\u53f0\u8f93\u5165");
                pwd = console.readPassword("Password:", new Object[0]);
            }
        }
        if (StrUtils.isEmpty(pwd)) {
            Log.debug("\u65e0\u6cd5\u4ece\u63a7\u5236\u53f0\u4e2d\u83b7\u53d6\u5bc6\u7801\uff0cGUI\u8f93\u5165");
            InputForm input = new InputForm();
            boolean gui = input.showForm();
            if (gui) {
                Log.debug("GUI\u8f93\u5165");
                pwd = input.nextPasswordLine();
                input.closeForm();
            }
        }
        if (StrUtils.isEmpty(pwd)) {
            Log.println("\nERROR: Startup failed, could not get the password.\n");
            System.exit(0);
        }
        if ((passHash = JarDecryptor.readEncryptedFile(new File(JarUtils.getRootPath(null)), "org.springframework.config.PassHash")) != null) {
            char[] p1 = StrUtils.toChars(passHash);
            char[] p2 = EncryptUtils.md5(StrUtils.merger(pwd, EncryptUtils.SALT));
            if (!StrUtils.equal(p1, p2 = EncryptUtils.md5(StrUtils.merger(EncryptUtils.SALT, p2)))) {
                Log.println("\nERROR: Startup failed, invalid password.\n");
                System.exit(0);
            }
        }
        if (inst != null) {
            AgentTransformer tran = new AgentTransformer(pwd);
            inst.addTransformer(tran);
        }
    }

    public static char[] readPasswordFromFile(CmdLineOption options) {
        String configName;
        String path = JarUtils.getRootPath(null);
        if (!path.endsWith(".jar")) {
            return null;
        }
        String jarName = path.substring(path.lastIndexOf("/") + 1);
        File config = new File(path = path.substring(0, path.lastIndexOf("/") + 1), configName = jarName.substring(0, jarName.length() - 3) + "classencrypt.txt");
        if (!config.exists()) {
            config = new File(path, "classencrypt.txt");
        }
        String args = null;
        if (config.exists()) {
            args = IoUtils.readTxtFile(config);
        }
        if (StrUtils.isEmpty(args)) {
            return null;
        }
        if (!args.contains(" ")) {
            return args.trim().toCharArray();
        }
        options.parse(args.trim().split(" "));
        char[] pwd = options.getOptionValue("pwd", "").toCharArray();
        Const.DEBUG = options.hasOption("debug");
        if (!"false".equalsIgnoreCase(options.getOptionValue("del")) && !"no".equalsIgnoreCase(options.getOptionValue("del"))) {
            args = "";
            IoUtils.writeTxtFile(config, args);
        }
        return pwd;
    }
}

