package com.wecloud.im.ws.enums;

/**
 * @Description ws响应类型
 * @Author xxxname xxxemail.com
 * @Date 2019-12-05
 */
public enum MsgTypeEnum {

    // 位置
    MEDIA_TYPE_NONE(0),
    // 文本消息
    MEDIA_TYPE_TEXT(-1),
    // 图像消息
    MEDIA_TYPE_IMAGE(-2),
    // 音频消息
    MEDIA_TYPE_AUDIO(-3),
    // 视频消息
    MEDIA_TYPE_VIDEO(-4),
    // 文件消息
    MEDIA_TYPE_FILE(-5),
    //    xx邀请xx加入会话 -1007
    INVITE_CLIENT_JOIN_CONVERSATION(-1007),

    //    xx被xx移出会话 -1008
    REMOVE_CLIENT_CONVERSATION(-1008),

    //    xx已接收某消息 -1009
    CLIENT_RECEIVED_MSG(-1009),

    //    xx已读某条消息 -1010
    CLIENT_READ_MSG(-1010),

    //    你被xx拉入新会话 -1011
    CLIENT_JOIN_NEW_CONVERSATION(-1011),

    //    主动退出会话 -1012
    LEAVE_CONVERSATION(-1012),


    //    成为新群主 -1013
    CONVERSATION_NEW_CREATOR(-1013),


    //    群拓展字段变动事件 -1014
    CONVERSATION_EXPAND_FIELD_CHANGE(-1014),

    //    会话名称字段变动事件 -1015
    CONVERSATION_NAME_CHANGE(-1015),

    //    消息撤回 -1016
    MSG_WITHDRAW(-1016),

    //    消息删除 -1017
    MSG_DELETE(-1017),

    //    解散群聊 -1018
    CONVERSATION_DISBAND(-1018),

    //    群聊禁言 -1019
    CONVERSATION_MUTED(-1019),

    //    群聊取消禁言 -1020
    CONVERSATION_MUTED_CANCEL(-1020),

    //    群成员备注修改 -1021
    CONVERSATION_MEMBER_NAME_MODIFY(-1021),

    // 禁止群成员互加好友
    CONVERSATION_FORBID_ADD_FRIEND(-1022),

    // 取消禁止群成员互加好友
    CONVERSATION_FORBID_ADD_FRIEND_CANCEL(-1023),

    // 禁止群成员发红包
    CONVERSATION_FORBID_SEND_RED_PACKETS(-1024),

    // 取消禁止群成员发红包
    CONVERSATION_FORBID_SEND_RED_PACKETS_CANCEL(-1025),

    // 禁止群成员发图片
    CONVERSATION_FORBID_SEND_PIC_CANCEL(-1026),

    // 取消禁止群成员发图片
    CONVERSATION_FORBID_SEND_PIC(-1027),

    // 禁止群成员发链接
    CONVERSATION_FORBID_SEND_LINK(-1028),

    // 取消禁止群成员发链接
    CONVERSATION_FORBID_SEND_LINK_CANCEL(-1029),

    // 修改群头像
    CONVERSATION_SET_GROUP_PORTRAIT(-1031),
    ;

    private final int uriCode;

    MsgTypeEnum(int uriCode) {
        this.uriCode = uriCode;
    }

    /**
     * 根据uriCode获取
     *
     * @param uriCode
     * @return
     */
    public static MsgTypeEnum getByCode(int uriCode) {
        for (MsgTypeEnum wsResponsePathEnum : values()) {
            if (wsResponsePathEnum.getUriCode() == uriCode) {
                return wsResponsePathEnum;
            }
        }
        return null;
    }

    public int getUriCode() {
        return uriCode;
    }
}
