package com.wecloud.im.service;

import com.wecloud.im.entity.ImMultiRtcRoom;
import io.geekidea.springbootplus.framework.common.service.BaseService;

/**
 * @Author wenzhida
 * @Date 2022/3/16 9:08
 * @Description 多人音视频房间服务接口
 */
public interface ImMultiRtcRoomService extends BaseService<ImMultiRtcRoom> {

    /**
     * 获取多人音视频房间
     * @param fkAppid
     * @param roomId
     * @return
     */
    ImMultiRtcRoom getCachedMultiRtcRoom(Long fkAppid, String roomId);

    /**
     * 清房间缓存
     * @param fkAppid
     * @param roomId
     */
    void deleteMultiRtcRoomCache(Long fkAppid, String roomId);

    /**
     * 更新多人音视频房间状态
     * @param roomId
     * @param state
     */
    void updateMultiRtcRoomState(String roomId, Integer state);

}
