package com.sien.common.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 捐款记录
 *
 * @author hewei
 * @since 2021-02-25
 */
@Data
public class DonationRecordAdd implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("捐款金额")
    private BigDecimal money;

    @ApiModelProperty("捐款用途;直接录入字符串: 助学助教,资助病残;慰问孤老,其他")
    private String purpose;

    @ApiModelProperty("捐款方式;1正常.2匿名,替他人捐款记录在donation_r agent表")
    private Integer way;

    @ApiModelProperty("是否替别人捐款")
    private Integer isReplace;

    @NotNull(message = "捐款接收用户手机号")
    @ApiModelProperty("捐款接收用户手机号")
    private String userPhone;
}
