package com.wecloud.im.controller;

import com.wecloud.im.enums.CallTypeEnum;
import com.wecloud.im.param.rtc.*;
import com.wecloud.rtc.service.RtcService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 音视频通话 控制器
 *
 * @author wei
 * @since 2021-10-18
 */
@Slf4j
@RestController
@RequestMapping("/rtc")
@Api(value = "音视频通话", tags = {"音视频通话"})
public class ImRtcController extends BaseController {

    @Autowired
    private RtcService rtcService;

    /**
     * 创建频道,并邀请客户端加入
     */
    @PostMapping("/createAndCall")
    @ApiOperation(value = "创建频道,并邀请客户端加入", notes = "创建频道,并邀请客户端加入")
    public ApiResult<CreateRtcChannelResult> createAndCall(@RequestBody CreateRtcChannelParam createRtcChannelParam) {
        if (BaseEnum.valueOf(CallTypeEnum.class, createRtcChannelParam.getCallType()) == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        return ApiResult.ok(rtcService.createAndCall(createRtcChannelParam));
    }


    @PostMapping("/join")
    @ApiOperation(value = "同意进入频道", notes = "")
    public ApiResult<Boolean> join(@RequestBody JoinRtcChannelParam joinRtcChannelParam) {
        rtcService.join(joinRtcChannelParam);
        return ApiResult.ok();
    }

    @PostMapping("/reject")
    @ApiOperation(value = "拒接进入频道", notes = "")
    public ApiResult<Boolean> reject(@RequestBody RejectRtcChannelParam rejectRtcChannelParam) {
        rtcService.reject(rejectRtcChannelParam);
        return ApiResult.ok();

    }

    @PostMapping("/leave")
    @ApiOperation(value = "主动挂断(离开频道)", notes = "")
    public ApiResult<Boolean> leave(@RequestBody LeaveRtcChannelParam leaveRtcChannelParam) {
        rtcService.leave(leaveRtcChannelParam);
        return ApiResult.ok();

    }

    @PostMapping("/sdpForward")
    @ApiOperation(value = "SDP数据转发", notes = "")
    public ApiResult<Boolean> sdpForward(@RequestBody SdpForwardParam sdpForwardParam) {
        rtcService.sdpForward(sdpForwardParam);
        return ApiResult.ok();

    }

    @PostMapping("/candidateForward")
    @ApiOperation(value = "candidate候选者数据转发", notes = "")
    public ApiResult<Boolean> candidateForward(@RequestBody CandidateForwardParam candidateForwardParam) {
        rtcService.candidateForward(candidateForwardParam);
        return ApiResult.ok();

    }

}

