package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.CharterIntroduction;
import com.jumeirah.common.param.CharterIntroductionPageParam;
import com.jumeirah.common.vo.CharterIntroductionQueryForAppVo;
import com.jumeirah.common.vo.CharterIntroductionQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 包机介绍 Mapper 接口
 *
 * @author giao
 * @since 2020-10-14
 */
@Repository
public interface CharterIntroductionMapper extends BaseMapper<CharterIntroduction> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    CharterIntroductionQueryVo getCharterIntroductionById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param charterIntroductionPageParam
     * @return
     */
    IPage<CharterIntroductionQueryVo> getCharterIntroductionPageList(@Param("page") Page page, @Param("param") CharterIntroductionPageParam charterIntroductionPageParam);

    IPage<CharterIntroductionQueryForAppVo> getCharterIntroductionForAppPageList(@Param("page") Page page, @Param("param") CharterIntroductionPageParam charterIntroductionPageParam);


}
