package com.wecloud.im.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

/**
 * 消息存储表
 *
 * @author wei
 * @since 2021-04-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImMessage对象")
public class ImMessage extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "消息id不能为空")
    @ApiModelProperty("消息id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("撤回时间")
    private Date withdrawTime;

    @ApiModelProperty("修改时间")
    private Date updateDate;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("发送者客户端id")
    private Long sender;

    @ApiModelProperty("接收人,多人用英文逗号分隔-群内指定人员可见场景")
    private String receivers;

    /**
     * 数据库字段类型为JSON格式
     * 因mysql关系型数据库非MongoDB文档类型数据库,第三方应用拓展的自定义参数名和值需使用json格式落库
     */
    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("0未撤回; 1已撤回")
    private Boolean withdraw;

    @ApiModelProperty("0非事件; 1为事件")
    private Boolean event;

    @ApiModelProperty("0非系统通知; 1为系统通知")
    private Boolean systemFlag;

    @ApiModelProperty("at他人,传入客户端id数组")
    private String at;

    @ApiModelProperty("1 AVIMMessageStatusSending（发送中）" +
            "2 AVIMMessageStatusSent（发送成功）" +
            "3 AVIMMessageStatusFailed（失败）")
    private Integer sendStatus;

    @ApiModelProperty("会话id")
    private Long fkConversationId;

    @ApiModelProperty("消息类型")
    private Integer msgType;

    @ApiModelProperty("是否删除 1-未删除 2-已删除")
    private Integer isDelete;

}
