/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.geekidea.springbootplus.framework.common.api;

/**
 * <p>
 * REST API 响应码
 * </p>
 *
 * @author geekidea
 * @since 2018-11-08
 */
public enum ApiCode {

    /**
     * 操作成功
     **/
    SUCCESS(200, "api.response.code.SUCCESS"),
    /**
     * 非法访问
     **/
    UNAUTHORIZED(401, "api.response.code.UNAUTHORIZED"),
    /**
     * 没有权限
     **/
    NOT_PERMISSION(403, "api.response.code.NOT_PERMISSION"),
    /**
     * 你请求的资源不存在
     **/
    NOT_FOUND(404, "api.response.code.NOT_FOUND"),
    /**
     * 操作失败
     **/
    FAIL(500, "api.response.code.FAIL"),
    /**
     * 登录失败
     **/
    LOGIN_EXCEPTION(4000, "api.response.code.LOGIN_EXCEPTION"),
    /**
     * 系统异常
     **/
    SYSTEM_EXCEPTION(5000, "api.response.code.SYSTEM_EXCEPTION"),
    /**
     * 请求参数校验异常
     **/
    PARAMETER_EXCEPTION(5001, "api.response.code.PARAMETER_EXCEPTION"),
    /**
     * 请求参数解析异常
     **/
    PARAMETER_PARSE_EXCEPTION(5002, "api.response.code.PARAMETER_PARSE_EXCEPTION"),
    /**
     * HTTP内容类型异常
     **/
    HTTP_MEDIA_TYPE_EXCEPTION(5003, "api.response.code.HTTP_MEDIA_TYPE_EXCEPTION"),
    /**
     * 系统处理异常
     **/
    SPRING_BOOT_PLUS_EXCEPTION(5100, "api.response.code.SPRING_BOOT_PLUS_EXCEPTION"),
    /**
     * 业务处理异常
     **/
    BUSINESS_EXCEPTION(5101, "api.response.code.BUSINESS_EXCEPTION"),
    /**
     * 数据库处理异常
     **/
    DAO_EXCEPTION(5102, "api.response.code.DAO_EXCEPTION"),
    /**
     * 验证码校验异常
     **/
    VERIFICATION_CODE_EXCEPTION(5103, "api.response.code.VERIFICATION_CODE_EXCEPTION"),
    /**
     * 登录授权异常
     **/
    AUTHENTICATION_EXCEPTION(5104, "api.response.code.AUTHENTICATION_EXCEPTION"),
    /**
     * 没有访问权限
     **/
    UNAUTHENTICATED_EXCEPTION(5105, "api.response.code.UNAUTHENTICATED_EXCEPTION"),
    /**
     * 没有访问权限
     **/
    UNAUTHORIZED_EXCEPTION(5106, "api.response.code.UNAUTHORIZED_EXCEPTION"),
    /**
     * JWT Token解析异常
     **/
    JWTDECODE_EXCEPTION(5107, "api.response.code.JWTDECODE_EXCEPTION"),

    /**
     * 默认的异常处理
     */
    HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION(5108, "api.response.code.HTTP_REQUEST_METHOD_NOT_SUPPORTED_EXCEPTION"),

    /**
     * 账号或密码错误
     */
    PWD_OR_USERNAME_ERROR(6001, "api.response.code.user.PWD_OR_USERNAME_ERROR"),

    /**
     * 旧手机号验证码错误
     */
    SMS_CODE_ERROR(6005, "api.response.code.user.SMS_CODE_ERROR"),

    /**
     * 注册时验证码错误
     */
    SMS_CODE_REGIST_ERROR(6007, "api.response.code.user.SMS_CODE_REGIST_ERROR"),


    /**
     * 新手机号验证码错误
     */
    SMS_CODE_ERROR_NEW(6002, "api.response.code.user.SMS_CODE_ERROR_NEW"),

    /**
     * 用户不存在
     */
    USER_NOT_FOUND(6003, "api.response.code.user.USER_NOT_FOUND"),

    /**
     * 微信code错误
     */
    USER_WECHAT_CODE(6004, "api.response.code.user.USER_WECHAT_CODE"),

    /**
     * 绑定手机已经被使用
     */
    UPDATA_PHONE_USE(6006, "api.response.code.user.UPDATA_PHONE_USE"),

    ;

    private final int code;
    private final String message;

    ApiCode(final int code, final String message) {
        this.code = code;
        this.message = message;
    }

    public static ApiCode getApiCode(int code) {
        ApiCode[] ecs = ApiCode.values();
        for (ApiCode ec : ecs) {
            if (ec.getCode() == code) {
                return ec;
            }
        }
        return SUCCESS;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

}
