package com.wecloud.im.thousandchat.controller;

import com.wecloud.im.thousandchat.param.LastestReceivedMsg;
import com.wecloud.im.thousandchat.service.ThousandChatService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 万人群消息处理controller
 */
@Slf4j
@RestController
@RequestMapping("/imState")
@Api(value = "万人群消息处理API", tags = {"万人群消息处理"})
public class ThousandChatController extends BaseController {

    @Autowired
    private ThousandChatService thousandChatService;

    /**
     * 消息修改为已接收状态
     */
    @PostMapping("/msgReceivedUpdate")
    @ApiOperation(value = "万人群消息修改为已接收状态")
    public ApiResult<Boolean> updateImMsgReceived(@RequestBody @Validated LastestReceivedMsg lastestReceivedMsg) {
        return thousandChatService.updateImMsgReceived(lastestReceivedMsg);
    }

    /**
     * 消息修改为已读状态
     */
    @PostMapping("/msgReadUpdate")
    @ApiOperation(value = "万人群消息修改为已读状态")
    public ApiResult<Boolean> updateInMsgReadUpdate(Long lastestMsgId) {
        return thousandChatService.updateImMsgRead(lastestMsgId);
    }

}

