package com.wecloud.im.mq;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.ws.model.request.PushVO;
import com.wecloud.pushserver.client.model.constant.MqConstant;
import com.wecloud.pushserver.client.model.dto.ImApplicationDTO;
import com.wecloud.pushserver.client.model.dto.ImClientDTO;
import com.wecloud.pushserver.client.model.dto.MessageDTO;
import com.wecloud.pushserver.client.model.dto.PushDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.producer.SendResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author wenzhida
 * @Date 2022/1/28 11:47
 * @Description mq推送服务
 */
@Slf4j
@Component
public class MqSender {

    @Autowired
    private ImInboxService imInboxService;

    @Autowired
    private RocketMqProducerService rocketMqProducerService;

    /**
     * mq同步推送方法
     * @param topic
     * @param tag
     * @param pushDTO
     * @return
     */
    public SendResult synSend(String topic, String tag, PushDTO pushDTO) {
        log.info("mq同步推送topic: {} tag: {} 推送内容: {}", topic, tag, JSON.toJSONString(pushDTO));
        SendResult sendResult = rocketMqProducerService.synSend(topic, tag, JSON.toJSONString(pushDTO));
        log.info("mq同步推送topic: {} tag: {} 返回结果: {}", topic, tag, JSON.toJSONString(sendResult));
        return sendResult;
    }


    public PushDTO buildPushDto(PushVO pushVO, ImClient imClientReceiver, ImApplication imApplication) {
        PushDTO pushDTO = new PushDTO();
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setTitle(pushVO.getTitle());
        messageDTO.setSubTitle(pushVO.getSubTitle());
        messageDTO.setData(pushVO.getData());
        // 统计未读消息数量
        int badge = imInboxService.countMyNotReadCount(imClientReceiver.getId());
        messageDTO.setBadge(badge);
        ImClientDTO imClientDTO = new ImClientDTO();
        imClientDTO.setClientId(imClientReceiver.getClientId());
        imClientDTO.setValid(imClientReceiver.getValid());
        imClientDTO.setDeviceType(imClientReceiver.getDeviceType());
        imClientDTO.setDeviceToken(imClientReceiver.getDeviceToken());
        messageDTO.setImClientDTO(imClientDTO);
        ImApplicationDTO imApplicationDTO = new ImApplicationDTO();
        imApplicationDTO.setId(imApplication.getId());
        imApplicationDTO.setAppKey(imApplication.getAppKey());
        imApplicationDTO.setAppSecret(imApplication.getAppSecret());
        imApplicationDTO.setAppName(imApplication.getAppName());
        imApplicationDTO.setIosPushChannel(imApplication.getIosPushChannel());
        imApplicationDTO.setAndroidPushChannel(imApplication.getAndroidPushChannel());
        imApplicationDTO.setUmengKey(imApplication.getUmengKey());
        imApplicationDTO.setUmengSecret(imApplication.getUmengSecret());
        imApplicationDTO.setFirebaseSecret(imApplication.getFirebaseSecret());
        messageDTO.setImApplicationDTO(imApplicationDTO);
        pushDTO.setMessageDTOList(Lists.newArrayList(messageDTO));
        return pushDTO;
    }
}
