package com.wecloud.im.sdk.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;

/**
 * <pre>
 * 会话表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2021-05-07
 */
@Data
@Accessors(chain = true)
public class Conversation implements Serializable {

    private static final long serialVersionUID = 8120459168840854991L;

    /**
     * "会话id"
     */
    private Long id;

    /**
     * "创建时间"
     */
    private Date createTime;

    /**
     * "创建者客户端id"
     */
    private String creator;

    /**
     * "可选	 对话的名字，可为群组命名。"
     */
    private String name;

    /**
     * value = "可选	自定义属性，供开发者扩展使用。", hidden = true
     */
    private String attribute;

    /**
     * "可选	自定义属性，供开发者扩展使用。"
     */
    private HashMap attributes;

    /**
     * "可选	对话类型标志，是否是系统对话，后面会说明。"
     */
    private Boolean systemFlag;

    /**
     * "未读消息条数"
     */
    private Long msgNotReadCount;

    /**
     * "成员"
     */
    private String members;

    /**
     * "会话属性，1：单聊，2：普通群，3：万人群"
     */
    private Integer chatType;

    /**
     * "群成员数"
     */
    private Integer memberCount;

    /**
     * "是否被@ true-是 false-否"
     */
    private Boolean isBeAt;

    /**
     * 禁言开关
     * @see com.wecloud.im.sdk.enums.MutedEnum
     */
    /**
     * "禁言开关 1-未禁言 2-禁言"
     */
    private Integer muted;

    /**
     * "禁言开关 1-未禁言 2-禁言"
     */
    private Integer beAtCount;

    /**
     * "禁止互加好友"
     */
    private Boolean forbidAddFriend;

    /**
     * "禁止发红包"
     */
    private Boolean forbidSendRedPackets;

    /**
     * "禁止发图片"
     */
    private Boolean forbidSendPic;

    /**
     * "禁止发链接"
     */
    private Boolean forbidSendLink;

}
