package com.wecloud.im.sdk.enums;

/**
 * @Author wenzhida
 * @Date 2022/3/2 17:15
 * @Description 设备类型枚举
 */
public enum DeviceTypeEnum {

    IOS(1, "IOS端"),
    ANDROID(2, "安卓端"),
    WEB(3, "web端"),
    WIN(4, "PC-windows端"),
    MAC(5, "PC-macOs端");

    private final Integer code;
    private final String desc;

    DeviceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}
