package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <pre>
 * 捐款记录 查询结果对象
 * </pre>
 *
 * @author hewei
 * @date 2021-02-25
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "VipRecordQueryVo对象")
public class VipRecordQueryVo implements Serializable{
private static final long serialVersionUID=1L;

        @ApiModelProperty("主键")
private Long id;

        @ApiModelProperty("外键_用户表")
private Long fkUserId;

        @ApiModelProperty("开通人,因为可以给其他人开通,所以要有对应的谁给我充值的")
private Long fkRechargeUser;

        @ApiModelProperty("开通会员金额")
private BigDecimal money;

        @ApiModelProperty("到期时间")
private Date expiredAt;

        @ApiModelProperty("开通多久")
private Integer years;

        @ApiModelProperty("会员等级")
private String vipLevel;

        @ApiModelProperty("备注")
private String remark;

        @ApiModelProperty("创建时间")
private Date createTime;

        @ApiModelProperty("修改时间")
private Date updateTime;
}