package com.wecloud.im.tillo.app_ws.model.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Description null
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReceiveModel implements Serializable {

    /**
     * 枚举类UriPathEnum 请求uri的编码
     * 由于websocket使用同一个通道发送数据，需要区分不同类型请求
     */
    private Integer path;

    /**
     * json数据
     */
    private String data;

    /**
     * 请求id, 以判空是否请求成功, 服务端处理完成后 返回此id
     * 由前端生成，可以用uuid，也可以用时间戳
     */
    private String reqId;
}
